"use strict";

this.name = "gl-market";
this.author = "Reval";

/* Thanks to Spara for producing this code! */
this.updateLocalCommodityDefinition = function(goodDefinition, station) {

	var distance = station.position.distanceTo(system.mainStation);
	
	//scale max price difference with distance
	//1000 km -> 0.05, 5000 km -> 0.15
	var maxPriceDiff = 0.000000025 * distance + 0.025;
	var priceDiff = Math.random() * maxPriceDiff;
	
	//cheaper or more expensive?
	var coinToss = Math.round(Math.random());
	if (coinToss === 0)  var priceMultiplier = 1 - priceDiff;
	else var priceMultiplier = 1 + priceDiff;
	
	goodDefinition.price *= priceMultiplier;
	
	//scale quantity with random +/- 100 % scale
	
	var quantityDiff = Math.random();
	var coinToss = Math.round(Math.random());
	if (coinToss === 0) var quantityMultiplier = 1 - quantityDiff;
	else var quantityMultiplier = 1 + quantityDiff;
	
	goodDefinition.quantity = Math.round(quantityMultiplier * goodDefinition.quantity);

	return goodDefinition;
};
